package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.TNotificationState;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("NotificationChannelState")
@ParametersAreNullableByDefault
public class NotificationStateDto {
    @ApiModelProperty(
        value = "Notification channel identifier",
        readOnly = true,
        position = 0)
    public String channelId;

    @ApiModelProperty(
        value = "Last time when notification was triggered",
        readOnly = true,
        dataType = "java.time.Instant",
        position = 1)
    public String latestEval;

    @ApiModelProperty(
        value = "Last time when notification was successfully delivered",
        readOnly = true,
        dataType = "java.time.Instant",
        position = 2)
    public String latestSuccess;

    @ApiModelProperty(
        value = "Status of the last delivery",
        readOnly = true,
        position = 3)
    public String lastStatus;

    @ApiModelProperty(
        value = "Details about channel status",
        readOnly = true,
        position = 4)
    public String lastStatusDescription;

    public static NotificationStateDto fromProto(@Nonnull TNotificationState notificationState) {
        var dto = new NotificationStateDto();

        dto.channelId = notificationState.getNotificationChannelId();
        dto.latestEval = Instant.ofEpochMilli(notificationState.getLatestEvalMillis()).toString();
        dto.latestSuccess = Instant.ofEpochMilli(notificationState.getLatestSuccessMillis()).toString();
        dto.lastStatus = notificationState.getStatus().getCode().name();
        dto.lastStatusDescription = notificationState.getStatus().getDesctiption();

        return dto;
    }
}
