package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.EOrderDirection;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum OrderDirection {
    INVALID,
    ASC,
    DESC,
    ;

    public EOrderDirection toProto() {
        switch (this) {
            case ASC:
                return EOrderDirection.ASC;
            case DESC:
                return EOrderDirection.DESC;
            default:
                return EOrderDirection.UNRECOGNIZED;
        }
    }
}
