package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudPushType;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("SmsChannelSettings")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushChannelSettingsDto {
    @ApiModelProperty(
        value = "List of recipient's IAM ids",
        required = true,
        position = 10)
    public List<String> recipientIds;

    public static PushChannelSettingsDto fromProto(@Nonnull TCloudPushType sms) {
        var dto = new PushChannelSettingsDto();

        dto.recipientIds = sms.getRecipientsList();

        return dto;
    }

    public TCloudPushType toProto() {
        validate();

        return TCloudPushType.newBuilder()
            .addAllRecipients(recipientIds)
            .build();
    }

    private void validate() {
        Validators.checkPresent(recipientIds, "recipientIds");
        Validators.checkNonEmpty(recipientIds, "recipientIds");
    }
}
