package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.alert.protobuf.notification.TCloudSmsType;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("SmsChannelSettings")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SmsChannelSettingsDto {
    @ApiModelProperty(
        value = "List of recipient's IAM ids",
        required = true,
        position = 10)
    public List<String> recipientIds;

    public static SmsChannelSettingsDto fromProto(@Nonnull TCloudSmsType sms) {
        var dto = new SmsChannelSettingsDto();

        dto.recipientIds = sms.getRecipientsList();

        return dto;
    }

    public TCloudSmsType toProto() {
        validate();

        return TCloudSmsType.newBuilder()
            .addAllRecipients(recipientIds)
            .build();
    }

    private void validate() {
        Validators.checkPresent(recipientIds, "recipientIds");
        Validators.checkNonEmpty(recipientIds, "recipientIds");
    }
}
