package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.EThresholdType;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum TimeAggregation {
    UNKNOWN,
    AT_LEAST_ONE,
    AT_ALL_TIMES,
    LAST_NON_NAN,
    AVG,
    MIN,
    MAX,
    SUM,
    COUNT,
    ;

    public static TimeAggregation fromProto(EThresholdType thresholdType) {
        switch (thresholdType) {
            case AT_LEAST_ONE:
                return AT_LEAST_ONE;
            case AT_ALL_TIMES:
                return AT_ALL_TIMES;
            case LAST_NON_NAN:
                return LAST_NON_NAN;
            case AVG:
                return AVG;
            case MIN:
                return MIN;
            case MAX:
                return MAX;
            case SUM:
                return SUM;
            case COUNT:
                return COUNT;
            default:
                return UNKNOWN;
        }
    }

    public EThresholdType toProto() {
        switch (this) {
            case AT_LEAST_ONE:
                return EThresholdType.AT_LEAST_ONE;
            case AT_ALL_TIMES:
                return EThresholdType.AT_ALL_TIMES;
            case LAST_NON_NAN:
                return EThresholdType.LAST_NON_NAN;
            case AVG:
                return EThresholdType.AVG;
            case MIN:
                return EThresholdType.MIN;
            case MAX:
                return EThresholdType.MAX;
            case SUM:
                return EThresholdType.SUM;
            case COUNT:
                return EThresholdType.COUNT;
            default:
                return EThresholdType.UNRECOGNIZED;
        }
    }
}
