package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.alert.protobuf.notification.ENotificationChannelType;
import ru.yandex.solomon.alert.protobuf.notification.TNotification;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public enum TransportType {
    NOT_FOUND,
    UNKNOWN,
    EMAIL,
    SMS,
    PUSH,
    ;

    public static TransportType fromProto(TNotification.TypeCase typeCase) {
        return switch (typeCase) {
            case CLOUDEMAIL -> EMAIL;
            case CLOUDSMS -> SMS;
            case CLOUDPUSH -> PUSH;
            default -> UNKNOWN;
        };
    }

    public static TransportType fromProto(ENotificationChannelType typeCase) {
        return switch (typeCase) {
            case CLOUD_EMAIL -> EMAIL;
            case CLOUD_SMS -> SMS;
            case CLOUD_PUSH -> PUSH;
            default -> UNKNOWN;
        };
    }

    public ENotificationChannelType toProto() {
        return switch (this) {
            case SMS -> ENotificationChannelType.CLOUD_SMS;
            case EMAIL -> ENotificationChannelType.CLOUD_EMAIL;
            case PUSH -> ENotificationChannelType.CLOUD_PUSH;
            default -> ENotificationChannelType.UNKNOWN;
        };
    }
}
