package ru.yandex.solomon.gateway.api.cloud.v1.dto;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public class Validators {
    public static void checkPresent(@Nullable Object param, String name) {
        if (param == null) {
            throw new BadRequestException("missing parameter \"" + name + "\"");
        }
    }

    public static void checkPositive(int value, String name) {
        if (value <= 0) {
            throw new BadRequestException("parameter \"" + name + "\" must be positive");
        }
    }

    public static void checkPositive(long value, String name) {
        if (value <= 0) {
            throw new BadRequestException("parameter \"" + name + "\" must be positive");
        }
    }

    public static void checkNonNegative(int value, String name) {
        if (value < 0) {
            throw new BadRequestException("parameter \"" + name + "\" must be positive");
        }
    }

    public static void checkNonNegative(long value, String name) {
        if (value < 0) {
            throw new BadRequestException("parameter \"" + name + "\" must be positive");
        }
    }

    public static void checkNonEmpty(String value, String name) {
        if (value.isEmpty()) {
            throw new BadRequestException("parameter \"" + name + "\" can't be empty");
        }
    }

    public static <T> void checkNonEmpty(Collection<T> value, String name) {
        if (value.isEmpty()) {
            throw new BadRequestException("parameter \"" + name + "\" can't be empty");
        }
    }

    public static <T> void checkKnown(Enum value, String name) {
        if (value.name().equals("UNKNOWN")) {
            throw new BadRequestException("parameter \"" + name + "\" has invalid value: UNKNOWN");
        }
    }
}
