package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.expr.func.SelFuncArgument;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("Argument")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class ArgumentDto {
    @ApiModelProperty(position = 0)
    public String name;
    @ApiModelProperty(position = 1, required = true)
    public TypeDto type;
    @ApiModelProperty(value = "Description of argument", position = 2)
    public String help;
    @ApiModelProperty(value = "Available values for argument", position = 3)
    public List<String> availableValues;

    public static ArgumentDto toDto(@Nonnull SelFuncArgument arg) {
        var type = TypeDto.toDto(arg.getType());
        if (type == null) {
            return null;
        }
        var result = new ArgumentDto();
        result.name = arg.getName();
        result.type = type;
        result.help = arg.getHelp();
        result.availableValues = arg.getAvailableValues();
        return result;
    }
}
