package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.expr.func.SelFunc;
import ru.yandex.solomon.expression.expr.func.SelFuncCategory;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class FuncDto {
    @ApiModelProperty(value = "Name of function", position = 0, required = true)
    public String name;
    @ApiModelProperty(value = "Short help by use function", position = 1)
    public String help;
    @ApiModelProperty(value = "Category", position =  2)
    public SelFuncCategory category;
    @ApiModelProperty(value = "Argument list", position = 3)
    public List<ArgumentDto> args;
    @ApiModelProperty(value = "Return type", position = 4, required = true)
    public TypeDto returnType;

    @Nullable
    public static FuncDto toDto(@Nonnull SelFunc func) {
        var result = new FuncDto();
        result.name = func.getName();
        result.help = func.getHelp();
        result.category = func.getCategory();
        result.args = func.getArgs().stream().map(ArgumentDto::toDto).collect(Collectors.toList());
        result.returnType = TypeDto.toDto(func.getReturnType());

        if (result.returnType == null || result.args.stream().anyMatch(Objects::isNull)) {
            return null;
        }
        return result;
    }
}
