package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.Objects;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.exceptions.ParserException;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("ParseError")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ParseErrorDto {
    @ApiModelProperty(value = "Position range where the error has occurred", position = 0, accessMode = READ_ONLY)
    public PositionRangeDto position;
    @ApiModelProperty(value = "Error message", position = 1, accessMode = READ_ONLY)
    public String message;

    public ParseErrorDto(@Nonnull ParserException e) {
        this.position = new PositionRangeDto(e.getRange());
        this.message = e.getErrorMessage();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ParseErrorDto that = (ParseErrorDto) o;
        return Objects.equals(position, that.position) &&
                Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(position, message);
    }
}
