package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("ParseRequest")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ParseRequestDto {
    @ApiModelProperty(value = "Program code", position = 0, required = true)
    public String program;

    @ApiModelProperty(value = "Emit position information", position = 1)
    public Boolean needPositions;

    public ParseRequestDto() {
    }

    @VisibleForTesting
    public ParseRequestDto(String program) {
        this(program, null);
    }

    @VisibleForTesting
    public ParseRequestDto(String program, Boolean needPositions) {
        this.program = program;
        this.needPositions = needPositions;
    }
}
