package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("ParseResponse")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ParseResponseDto {
    @ApiModelProperty(value = "Program AST if parsed successfully", position = 0, accessMode = READ_ONLY)
    public ProgramAstDto programAst;

    @ApiModelProperty(value = "First parsing error", position = 1, accessMode = READ_ONLY)
    public ParseErrorDto firstParsingError;
}
