package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.Position;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("Position")
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PositionDto {
    @ApiModelProperty(value = "Line, starting from 1", position = 0, accessMode = READ_ONLY)
    public int line;
    @ApiModelProperty(value = "Column, starting from 1", position = 1, accessMode = READ_ONLY)
    public int column;
    @ApiModelProperty(value = "Global program offset, starting from 0", position = 2, accessMode = READ_ONLY)
    public int offset;

    public PositionDto(Position pos) {
        line = pos.getLine();
        column = pos.getColumn();
        offset = pos.getOffset();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PositionDto that = (PositionDto) o;
        return line == that.line &&
                column == that.column &&
                offset == that.offset;
    }

    @Override
    public int hashCode() {
        return Objects.hash(line, column, offset);
    }

    @Override
    public String toString() {
        return "PositionDto{" +
                "line=" + line +
                ", column=" + column +
                ", offset=" + offset +
                '}';
    }
}
