package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.Objects;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.PositionRange;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("PositionRange")
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PositionRangeDto {
    @ApiModelProperty(value = "The beginning of the range", position = 0, accessMode = READ_ONLY)
    public PositionDto begin;
    @ApiModelProperty(value = "The ending of the range", position = 1, accessMode = READ_ONLY)
    public PositionDto end;

    public PositionRangeDto(PositionRange range) {
        begin = new PositionDto(range.getBegin());
        end = new PositionDto(range.getEnd());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PositionRangeDto that = (PositionRangeDto) o;
        return begin.equals(that.begin) &&
                end.equals(that.end);
    }

    @Override
    public int hashCode() {
        return Objects.hash(begin, end);
    }

    @Override
    public String toString() {
        return "PositionRangeDto{" +
                "begin=" + begin +
                ", end=" + end +
                '}';
    }
}
