package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import ru.yandex.solomon.expression.analytics.ProgramWithReturn;
import ru.yandex.solomon.expression.ast.Ast;
import ru.yandex.solomon.expression.ast.serialization.AstMappingContext;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("ProgramAst")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProgramAstDto {

    @ApiModelProperty(value = "List of intermediate variables", position = 0, accessMode = READ_ONLY)
    public List<ObjectNode> variables;
    @ApiModelProperty(value = "Query return expression", position = 1, accessMode = READ_ONLY)
    public ObjectNode expression;

    private static ObjectNode render(@Nonnull Ast ast, boolean includeRanges) {
        return new AstMappingContext(includeRanges).render(ast);
    }

    public ProgramAstDto(@Nonnull ProgramWithReturn programWithReturn, boolean includeRanges) {
        variables = programWithReturn.getStatements().stream()
                .map(statement -> render(statement, includeRanges))
                .collect(Collectors.toList());
        expression = render(programWithReturn.getExpr(), includeRanges);
    }
}
