package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("RenderError")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RenderErrorDto {
    @ApiModelProperty(value = "Error message", position = 0, accessMode = READ_ONLY)
    public String message;

    public RenderErrorDto(@Nonnull RuntimeException e) {
        message = e.getMessage();
    }
}
