package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("RenderRequest")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RenderRequestDto {
    @ApiModelProperty(value = "Expression ast to render", position = 0, required = true)
    public ObjectNode ast;

    public RenderRequestDto() {
    }

    @VisibleForTesting
    public RenderRequestDto(ObjectNode ast) {
        this.ast = ast;
    }
}
