package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import static io.swagger.annotations.ApiModelProperty.AccessMode.READ_ONLY;

/**
 * @author Ivan Tsybulin
 */
@ApiModel("RenderResponse")
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RenderResponseDto {
    @ApiModelProperty(value = "Rendered program, if succeeded", position = 0, accessMode = READ_ONLY)
    public String program;

    @ApiModelProperty(value = "Rendering error, if occurred", position = 1, accessMode = READ_ONLY)
    public RenderErrorDto renderingError;
}
