package ru.yandex.solomon.gateway.api.cloud.v1.dto.el;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;

import ru.yandex.solomon.expression.type.SelType;
import ru.yandex.solomon.expression.type.SelTypes;

/**
 * @author Vladimir Gordiychuk
 */
@ApiModel("Type")
@ParametersAreNonnullByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public enum TypeDto {
    BOOL("bool"),
    SCALAR("scalar"),
    STRING("string"),
    TIMESERIES("timeseries"),
    DURATION("duration"),
    SCALAR_VECTOR("scalar_vector"),
    STRING_VECTOR("string_vector"),
    TIMESERIES_VECTOR("timeseries_vector");

    private static final Map<SelType, TypeDto> MAPPING =
        Map.ofEntries(
            Map.entry(SelTypes.BOOLEAN, BOOL),
            Map.entry(SelTypes.DOUBLE, SCALAR),
            Map.entry(SelTypes.STRING, STRING),
            Map.entry(SelTypes.GRAPH_DATA, TIMESERIES),
            Map.entry(SelTypes.DURATION, DURATION),

            Map.entry(SelTypes.DOUBLE_VECTOR, SCALAR_VECTOR),
            Map.entry(SelTypes.STRING_VECTOR, STRING_VECTOR),
            Map.entry(SelTypes.GRAPH_DATA_VECTOR, TIMESERIES_VECTOR));

    @Nullable
    public static TypeDto toDto(SelType type) {
        return MAPPING.get(type);
    }

    private final String type;

    TypeDto(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return type;
    }

}
