package ru.yandex.solomon.gateway.api.cloud.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.config.gateway.TGatewayCloudConfig;
import ru.yandex.solomon.spring.ConditionalOnBean;

/**
 * @author Oleg Baryshnikov
 */
@Component
@ConditionalOnBean(TGatewayCloudConfig.class)
@ParametersAreNonnullByDefault
public class PrometheusMetricsClientMetrics implements MetricSupplier {
    private final ConcurrentHashMap<String, FolderServiceMetrics> metricsByFolderServiceId;

    @Autowired
    public PrometheusMetricsClientMetrics() {
        this.metricsByFolderServiceId = new ConcurrentHashMap<>(10);
    }

    public FolderServiceMetrics getFolderServiceMetrics(String cloudId, String folderId, String service) {
        var result = metricsByFolderServiceId.get(folderId);
        if (result != null) {
            return result;
        }

        return metricsByFolderServiceId.computeIfAbsent(folderId + ":" + service, ignored -> new FolderServiceMetrics(cloudId, folderId, service));
    }

    @Override
    public int estimateCount() {
        return metricsByFolderServiceId.size() * 6;
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        var total = new FolderServiceMetrics("total", "total", "total");
        var aggrMetricById = new HashMap<String, FolderServiceMetrics>();

        for (var folderServiceMetrics : metricsByFolderServiceId.values()) {
            folderServiceMetrics.append(tsMillis, commonLabels, consumer);
            combineAggrMetrics(folderServiceMetrics, aggrMetricById, folderServiceMetrics.cloudId, "total", "total");
            combineAggrMetrics(folderServiceMetrics, aggrMetricById, folderServiceMetrics.cloudId, folderServiceMetrics.folderId, "total");
            combineAggrMetrics(folderServiceMetrics, aggrMetricById, folderServiceMetrics.cloudId, "total", folderServiceMetrics.service);
            combineAggrMetrics(folderServiceMetrics, aggrMetricById, "total", folderServiceMetrics.folderId, "total");
            combineAggrMetrics(folderServiceMetrics, aggrMetricById, "total", "total", folderServiceMetrics.service);
            total.combine(folderServiceMetrics);
        }

        for (var aggrMetric : aggrMetricById.values()) {
            aggrMetric.append(tsMillis, commonLabels, consumer);
        }

        total.append(tsMillis, commonLabels, consumer);
    }

    private static void combineAggrMetrics(
        FolderServiceMetrics folderServiceMetrics,
        Map<String, FolderServiceMetrics> aggrMetricById,
        String cloudId,
        String folderId,
        String serviceId)
    {
        var aggrMetric = aggrMetricById.computeIfAbsent(
            cloudId + "/" + folderId + "/" + serviceId,
            ignored -> new FolderServiceMetrics(cloudId, folderId, serviceId));
        aggrMetric.combine(folderServiceMetrics);
    }
}
