package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.label.LabelConf;
import ru.yandex.solomon.gateway.api.cloud.v1.dto.LabelKeysResponseDto;
import ru.yandex.solomon.metrics.client.LabelNamesResponse;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListLabelKeysResultDto {

    @JsonProperty
    private final String[] keys;

    private ListLabelKeysResultDto(String[] keys) {
        this.keys = keys;
    }

    public static ListLabelKeysResultDto fromModel(LabelNamesResponse response) {
        LabelKeysResponseDto dto = new LabelKeysResponseDto();
        String[] keys = response.getNames().stream()
            .sorted(LabelConf.getPartialSorterComparator())
            .toArray(String[]::new);
        return new ListLabelKeysResultDto(keys);
    }
}
