package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.labels.validate.LabelValidationFilter;
import ru.yandex.solomon.labels.protobuf.LabelValidationFilterConverter;
import ru.yandex.solomon.metrics.client.LabelValuesResponse;
import ru.yandex.solomon.util.labelStats.LabelStats;
import ru.yandex.solomon.util.labelStats.LabelValuesStats;
import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListLabelValuesResultDto {

    @JsonProperty
    private final String[] values;
    @JsonProperty
    private final boolean absent;
    @JsonProperty
    private final long metricsCount;
    @JsonProperty
    private final String nextPageToken = null; // temporarily not used

    private ListLabelValuesResultDto(String[] values, boolean absent, long metricsCount) {
        this.values = values;
        this.absent = absent;
        this.metricsCount = metricsCount;
    }

    public static ListLabelValuesResultDto fromModel(
        LabelValuesResponse model,
        ru.yandex.solomon.metabase.protobuf.LabelValidationFilter protoValidationFilter)
    {
        LabelValuesStats labelValuesStats = model.getLabelValuesStats();
        if (labelValuesStats.getStatsByLabelKey().isEmpty()) {
            return new ListLabelValuesResultDto(new String[0], false, 0);
        }

        LabelStats labelStats = labelValuesStats.getStatsByLabelKey().values().iterator().next();
        int metricsCount = labelValuesStats.getMetricsCount();
        boolean absent = labelStats.getCount() < metricsCount;

        LabelValidationFilter validationFilter = LabelValidationFilterConverter.protoToFilter(protoValidationFilter);

        String[] filteredAndSortedValues = labelStats.getValues().stream()
            .filter(validationFilter::filterValue)
            .sorted(TextWithNumbersComparator.instance)
            .toArray(String[]::new);

        return new ListLabelValuesResultDto(filteredAndSortedValues, absent, metricsCount);
    }
}
