package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.metrics.client.MetricNamesResponse;
import ru.yandex.solomon.util.text.TextWithNumbersComparator;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListMetricNamesResultDto {

    @JsonProperty
    private String[] names;
    @JsonProperty
    private final String nextPageToken = null; // temporarily not used

    private ListMetricNamesResultDto(String[] names) {
        this.names = names;
    }

    public static ListMetricNamesResultDto fromModel(MetricNamesResponse metricNamesResponse) {
        String[] names = metricNamesResponse.getNames()
            .stream()
            .sorted(TextWithNumbersComparator.instance)
            .toArray(String[]::new);
        return new ListMetricNamesResultDto(names);
    }
}
