package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.model.MetricKey;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ListMetricsResultDto {

    @JsonProperty
    private final MetricMetaDto[] metrics;
    @JsonProperty
    private final String nextPageToken = null; // temporarily not used

    private ListMetricsResultDto(MetricMetaDto[] metrics) {
        this.metrics = metrics;
    }

    public static ListMetricsResultDto fromModel(List<MetricKey> metrics) {
        MetricMetaDto[] metricDtos = metrics.stream()
            .map(MetricMetaDto::fromModel)
            .toArray(MetricMetaDto[]::new);
        return new ListMetricsResultDto(metricDtos);
    }
}
