package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.labels.LabelKeys;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MetricDataDto {

    @JsonProperty
    private final String name;
    @JsonProperty
    private final Map<String, String> labels;
    @JsonProperty
    private final MetricType type;
    @JsonProperty
    private final TimeseriesDto timeseries;

    private MetricDataDto(String name, Map<String, String> labels, MetricType type, TimeseriesDto timeseries) {
        this.name = name;
        this.labels = labels;
        this.type = type;
        this.timeseries = timeseries;
    }

    public static MetricDataDto fromModel(NamedGraphData namedGraphData) {
        MetricType type = MetricType.fromMetricType(namedGraphData.getType());
        String name = namedGraphData.getMetricName();
        Map<String, String> labels = namedGraphData.getLabels().toMap();
        labels.remove(LabelKeys.PROJECT);
        labels.remove(LabelKeys.CLUSTER);
        var data = namedGraphData.getAggrGraphDataArrayList();
        return new MetricDataDto(name, labels, type, TimeseriesDto.fromModel(type, namedGraphData.getDataType(), data));
    }

    public String getName() {
        return name;
    }

    public Map<String, String> getLabels() {
        return labels;
    }

    public MetricType getType() {
        return type;
    }

    public TimeseriesDto getTimeseries() {
        return timeseries;
    }
}
