package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.labels.LabelKeys;
import ru.yandex.solomon.model.MetricKey;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class MetricMetaDto {

    @JsonProperty
    private final String name;
    @JsonProperty
    private final Map<String, String> labels;
    @JsonProperty
    private final MetricType type;

    private MetricMetaDto(String name, Map<String, String> labels, MetricType type) {
        this.name = name;
        this.labels = labels;
        this.type = type;
    }

    public static MetricMetaDto fromModel(MetricKey key) {
        String name = key.getName();
        Map<String, String> labels = key.getLabels().toMap();
        labels.remove(LabelKeys.PROJECT);
        labels.remove(LabelKeys.CLUSTER);
        MetricType type = MetricType.fromMetricType(key.getType());
        return new MetricMetaDto(name, labels, type);
    }
}
