package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import java.util.Arrays;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.value.SelValue;
import ru.yandex.solomon.gateway.data.DataResponse;

/**
 * @author Sergey Polovko
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ReadResultDto {

    @JsonProperty
    private final MetricDataDto[] metrics;

    private ReadResultDto(MetricDataDto... metrics) {
        this.metrics = metrics;
    }

    public static ReadResultDto fromModel(@Nonnull DataResponse model) {
        SelValue selValue = model.getEvalResult();
        if (selValue.type().isGraphData()) {
            NamedGraphData namedGraphData = selValue.castToGraphData().getNamedGraphData();
            return new ReadResultDto(MetricDataDto.fromModel(namedGraphData));
        } else if (selValue.type().isVector()) {
            return new ReadResultDto(Arrays.stream(selValue.castToVector().valueArray())
                .map(selItem -> selItem.castToGraphData().getNamedGraphData())
                .map(MetricDataDto::fromModel)
                .toArray(MetricDataDto[]::new));
        }
        throw new IllegalArgumentException("unsupported result type: " + selValue.type());
    }
}
