package ru.yandex.solomon.gateway.api.cloud.v2.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;

/**
 * @author Sergey Polovko
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class WriteResultDto {

    @JsonProperty
    private final long writtenMetricsCount;
    @JsonProperty
    private final String errorMessage;

    public WriteResultDto(long writtenMetricsCount, String errorMessage) {
        this.writtenMetricsCount = writtenMetricsCount;
        this.errorMessage = Strings.emptyToNull(errorMessage);
    }
}
