package ru.yandex.solomon.gateway.api.internal;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.gateway.api.internal.dto.ExceptionSchemasDto;
import ru.yandex.solomon.gateway.data.exceptions.DataClientExceptionRegistry;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
@RestController
@RequestMapping(path = "/api/internal/exception", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class ExceptionSchemaController {
    @RequestMapping(path = "/schemas", method = RequestMethod.GET)
    public ExceptionSchemasDto schemas(@RequireAuth AuthSubject subject) {
        return new ExceptionSchemasDto(DataClientExceptionRegistry.PER_TYPE_SCHEMA);
    }
}
