package ru.yandex.solomon.gateway.api.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.Authorizer;
import ru.yandex.solomon.auth.http.RequireAuth;
import ru.yandex.solomon.auth.roles.Permission;
import ru.yandex.solomon.core.conf.DashboardsManager;
import ru.yandex.solomon.gateway.api.internal.dto.GraphOrDashboardItemDto;
import ru.yandex.solomon.labels.LabelsFormat;


/**
 * Special controller to support matching dashboards by labels.
 *
 * @author Oleg Baryshnikov
 */
@RestController
@RequestMapping(produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Import({ DashboardsManager.class })
public class MatchingDashboardsController {

    @Autowired
    private DashboardsManager dashboardsManager;
    @Autowired
    private Authorizer authorizer;


    @RequestMapping(path = "/api/internal/projects/{projectId}/matchingDashboards", method = RequestMethod.POST)
    CompletableFuture<List<GraphOrDashboardItemDto>> getDashboardsMatchingLabelsPost(
            @RequireAuth AuthSubject subject,
            @PathVariable("projectId") String projectId,
            @RequestBody Map<String, String> body)
    {
        String labels = body.getOrDefault("labels", "");
        Labels parsedLabels = LabelsFormat.parse(labels);
        return authorizer.authorize(subject, projectId, Permission.CONFIGS_LIST)
                .thenCompose(aVoid -> dashboardsManager.getAllDashboardsMatchingLabels(projectId, "", parsedLabels))
                .thenApply(dashboards -> dashboards.stream()
                        .map(dashboard -> GraphOrDashboardItemDto.fromModel(dashboard, parsedLabels))
                        .collect(Collectors.toList()));
    }
}
