package ru.yandex.solomon.gateway.api.internal;

import java.util.concurrent.CompletableFuture;

import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.solomon.core.exceptions.MethodNotAllowedException;

/**
 * Special controller to generate OAuth token for web application. Not allowed anymore.
 *
 * @author Oleg Baryshnikov
 */
@RestController
@RequestMapping(path = "/api/internal", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class OAuthTokenController {

    // For backward comparatively
    @RequestMapping(path = "/auth", method = RequestMethod.GET)
    CompletableFuture<String> getOAuthTokenOld(ServerHttpRequest request) {
        throw new MethodNotAllowedException("/api/internal/auth is not allowed");
    }

    @RequestMapping(path = "/oauth", method = RequestMethod.GET)
    public CompletableFuture<String> getOAuthToken(ServerHttpRequest request) {
        throw new MethodNotAllowedException("/api/internal/oauth is not allowed");
    }
}
