package ru.yandex.solomon.gateway.api.internal;

import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class ProjectSettingsValidator {
    static final String DISABLE_DASHBOARD_CONVERT = "disableDashboardConvert";
    static final String DISABLE_MENU_CONVERT = "disableMenuConvert";

    static final Set<String> KNOWN_KEYS = Set.of(DISABLE_DASHBOARD_CONVERT, DISABLE_MENU_CONVERT);

    static void validateKey(String key) {
        if (!KNOWN_KEYS.contains(key)) {
            throw new BadRequestException("unknown key: " + key);
        }
    }

    static void validateSetting(String key, String value) {
        switch (key) {
            case DISABLE_DASHBOARD_CONVERT:
            case DISABLE_MENU_CONVERT:
                validateBoolean(key, value);
                break;
            default:
                throw new BadRequestException("unknown key: " + key);
        }
    }

    static void validateSettings(Map<String, String> settings) {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            validateSetting(entry.getKey(), entry.getValue());
        }
    }

    private static void validateBoolean(String key, String value) {
        if (!StringUtils.isBlank(value) && !"true".equals(value) && !"false".equals(value)) {
            throw new BadRequestException('"' + key + "\" value must be a boolean");
        }
    }
}
