package ru.yandex.solomon.gateway.api.internal;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class UserSettingKeys {
    static final String SHOW_ALL_VALUES_IN_SELECTORS = "showAllValuesInSelectors";
    static final String REDIRECT_TO_NEW_UI = "redirectToNewUi";
    static final String MONITORING = "monitoring";
    static final String THEME = "theme";
    static final String LANGUAGE = "language";
    static final String UI = "ui";
    static final String HELP_TOOLTIPS = "helpTooltips";
    static final String SHARED_CROSSHAIR = "sharedCrosshair";
    static final String QUERY_VIEW_MODE = "queryViewMode";
    static final List<String> QUERY_VIEW_MODE_VALUES = List.of("text", "token");

    static final Set<String> KNOWN_KEYS = Set.of(
            SHOW_ALL_VALUES_IN_SELECTORS,
            REDIRECT_TO_NEW_UI,
            MONITORING,
            THEME,
            LANGUAGE,
            UI,
            HELP_TOOLTIPS,
            SHARED_CROSSHAIR,
            QUERY_VIEW_MODE
    );
}
