package ru.yandex.solomon.gateway.api.internal;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.solomon.core.exceptions.BadRequestException;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class UserSettingsValidator {

    static void validateKey(String key) {
        if (!isExperimentalKey(key) && !UserSettingKeys.KNOWN_KEYS.contains(key)) {
            throw new BadRequestException("unknown key: " + key);
        }
    }

    static void validateSetting(String key, String value) {
        if (isExperimentalKey(key)) {
            validateBoolean(key, value);
            return;
        }
        switch (key) {
            case UserSettingKeys.SHOW_ALL_VALUES_IN_SELECTORS:
            case UserSettingKeys.REDIRECT_TO_NEW_UI:
            case UserSettingKeys.SHARED_CROSSHAIR:
                validateBoolean(key, value);
                break;
            case UserSettingKeys.QUERY_VIEW_MODE:
                validateViewMode(key, value);
                break;
            case UserSettingKeys.MONITORING:
            case UserSettingKeys.THEME:
            case UserSettingKeys.UI:
            case UserSettingKeys.LANGUAGE:
            case UserSettingKeys.HELP_TOOLTIPS:
                break;
            default:
                throw new BadRequestException("unknown key: " + key);
        }
    }

    private static void validateViewMode(String key, String value) {
        if (!UserSettingKeys.QUERY_VIEW_MODE_VALUES.contains(value)) {
            throw new BadRequestException('"' + key + "\" value must be one of " + UserSettingKeys.QUERY_VIEW_MODE_VALUES);
        }
    }

    private static boolean isExperimentalKey(String key) {
        return key.startsWith("experimental");
    }

    static void validateSettings(Map<String, String> settings) {
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            validateSetting(entry.getKey(), entry.getValue());
        }
    }

    private static void validateBoolean(String key, String value) {
        if (!StringUtils.isBlank(value) && !"true".equals(value) && !"false".equals(value)) {
            throw new BadRequestException('"' + key + "\" value must be a boolean");
        }
    }
}
