package ru.yandex.solomon.gateway.api.internal.dto;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monitoring.v3.Favorite;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class FavoriteDto {
    @JsonProperty
    private final String type;

    @JsonProperty
    private final String id;

    @JsonProperty
    private final String name;

    public FavoriteDto(String type, String id, String name) {
        this.type = type;
        this.id = id;
        this.name = name;
    }

    public static FavoriteDto fromModel(Favorite model) {
        return new FavoriteDto(model.getType().name(), model.getId(), model.getName());
    }

    public String getId() {
        return id;
    }
    public String getType() {
        return type;
    }

    public String getName() {
        return name;
    }
}
