package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.Arrays;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.core.db.model.Selector;
import ru.yandex.solomon.core.db.model.ShortGraphOrDashboardConf;
import ru.yandex.solomon.gateway.api.v2.dto.SelectorDto;
import ru.yandex.solomon.labels.FormatLabel;
import ru.yandex.solomon.labels.LabelValues;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class GraphOrDashboardItemDto {

    @JsonProperty
    public String id;

    @JsonProperty
    public String name;

    @JsonProperty
    public SelectorDto[] parameters;

    public static GraphOrDashboardItemDto fromModel(
        @Nonnull ShortGraphOrDashboardConf graphOrDashboardConf,
        @Nonnull Labels labels)
    {
        GraphOrDashboardItemDto dto = new GraphOrDashboardItemDto();

        dto.id = graphOrDashboardConf.getId();
        dto.name = FormatLabel.formatLabel(graphOrDashboardConf.getName(), labels);
        dto.parameters = computeExactParameters(graphOrDashboardConf, labels);

        return dto;
    }

    @Nonnull
    private static SelectorDto[] computeExactParameters(
        @Nonnull ShortGraphOrDashboardConf graphOrDashboardConf,
        @Nonnull Labels labels)
    {
        return Arrays.stream(graphOrDashboardConf.getParameters())
            .map(Selector::getName)
            .map(paramName -> {
                Label labelByParamName = labels.findByKey(paramName);
                String exactValue =
                    labelByParamName == null ? LabelValues.ABSENT : labelByParamName.getValue();
                return SelectorDto.fromModel(paramName, exactValue);
            })
            .toArray(SelectorDto[]::new);
    }
}
