package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.ProjectSettings;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class ProjectSettingsDto {

    @JsonProperty
    public String id;

    @JsonProperty
    public Map<String, String> settings;

    public static ProjectSettingsDto fromModel(ProjectSettings model) {
        ProjectSettingsDto dto = new ProjectSettingsDto();
        dto.id = model.getId();
        dto.settings = model.getSettings();
        return dto;
    }
}
