package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.salmon.fetcher.proto.FetcherApiProto.THostInfo;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TResolveClusterResponse;
import ru.yandex.salmon.fetcher.proto.FetcherApiProto.TResolveResult;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResolveClusterResponseDto {
    public static class ResolveResultDto {
        @JsonProperty
        public String groupName;

        @JsonProperty
        public String errorMessage;

        @JsonProperty
        public List<HostInfoDto> hosts;
    }

    public static class HostInfoDto {
        @JsonProperty
        public String fqdn;

        @JsonProperty
        public int port;

        @JsonProperty
        public String labels;
    }

    @JsonProperty
    public List<ResolveResultDto> results;

    public static ResolveClusterResponseDto fromModel(@Nonnull TResolveClusterResponse model) {
        ResolveClusterResponseDto dto = new ResolveClusterResponseDto();
        dto.results = model.getResultsList().stream()
            .map(ResolveClusterResponseDto::fromResolveResultModel)
            .collect(Collectors.toList());
        return dto;
    }

    private static ResolveResultDto fromResolveResultModel(@Nonnull TResolveResult model) {
        ResolveResultDto dto = new ResolveResultDto();
        dto.groupName = model.getGroupName();
        switch (model.getResultCase()) {
            case HOSTS:
                dto.hosts = model.getHosts().getHostsList().stream()
                    .map(ResolveClusterResponseDto::fromHostInfoModel)
                    .collect(Collectors.toList());
                break;
            case ERRORMESSAGE:
                dto.errorMessage = model.getErrorMessage();
                break;
            case RESULT_NOT_SET:
                throw new IllegalStateException("unknown result case for resolve result: " + model.getResultCase());
        }
        return dto;
    }

    private static HostInfoDto fromHostInfoModel(@Nonnull THostInfo model) {
        HostInfoDto dto = new HostInfoDto();
        dto.fqdn = model.getFqdn();
        dto.port = model.getPort();
        dto.labels = model.getLabels();
        return dto;
    }
}
