package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.solomon.gateway.api.v2.dto.data.AggrPointDto;
import ru.yandex.solomon.gateway.api.v2.dto.data.StockpileKeyDto;
import ru.yandex.solomon.gateway.data.StockpileMetricDataResponse;
import ru.yandex.solomon.model.point.AggrPoint;
import ru.yandex.solomon.model.point.column.StockpileColumn;
import ru.yandex.solomon.model.timeseries.AggrGraphDataIterable;
import ru.yandex.solomon.model.timeseries.AggrGraphDataListIterator;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class StockpileDataResultDto {

    @JsonProperty
    public MetricType kind; // should be removed
    @JsonProperty
    public MetricType type;

    @JsonProperty
    public List<StockpileKeyDto> keys;

    @JsonProperty
    public List<StockpileColumn> columns;

    @JsonProperty
    public List<AggrPointDto> points;

    public static StockpileDataResultDto fromModel(
        StockpileMetricDataResponse model)
    {
        AggrGraphDataIterable aggrGraphData = model.getAggrGraphData();

        StockpileDataResultDto dto = new StockpileDataResultDto();

        dto.kind = model.getType();
        dto.type = model.getType();

        dto.keys = model.getStockpileKeys().stream()
            .map(StockpileKeyDto::fromModel)
            .collect(Collectors.toList());
        dto.columns = aggrGraphData.columnSet().columns();
        dto.points = pointDtos(aggrGraphData);
        return dto;
    }

    private static List<AggrPointDto> pointDtos(AggrGraphDataIterable aggrGraphData) {
        AggrPoint aggrPoint = new AggrPoint();

        AggrGraphDataListIterator iterator = aggrGraphData.iterator();

        List<AggrPointDto> points = new ArrayList<>(aggrGraphData.getRecordCount());

        while (iterator.next(aggrPoint)) {
            points.add(AggrPointDto.fromModel(aggrPoint));
        }
        return points;
    }
}
