package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.UserSettings;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class UserSettingsDto {

    @JsonProperty
    public String login;

    @JsonProperty
    public Map<String, String> settings;

    public static UserSettingsDto fromModel(UserSettings model) {
        UserSettingsDto dto = new UserSettingsDto();
        dto.login = model.getLogin();
        dto.settings = model.getSettings();
        return dto;
    }
}
