package ru.yandex.solomon.gateway.api.internal.dto;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNullableByDefault;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.solomon.core.db.model.ViewHistory;
import ru.yandex.solomon.util.collection.Nullables;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNullableByDefault
public class ViewHistoryDto {

    @JsonProperty
    private String id;
    @JsonProperty
    private String url;
    @JsonProperty
    private String title;

    @Nonnull
    public static ViewHistoryDto fromModel(@Nonnull ViewHistory model) {
        ViewHistoryDto dto = new ViewHistoryDto();
        dto.id = model.getId();
        dto.url = model.getUrl();
        dto.title = model.getPageTitle();
        return dto;
    }

    @Nonnull
    public ViewHistory toModel(@Nonnull String login) {
        return new ViewHistory(null, login, Nullables.orEmpty(url), title, true);
    }
}
