package ru.yandex.solomon.gateway.api.internal.dto;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.solomon.core.db.model.MenuItem;

/**
 * @author checat
 */
public class WwwMenuItemDto {

    private final String label;
    private final String hashUrl;
    private final List<WwwMenuItemDto> subMenuItems;

    public WwwMenuItemDto(MenuItem menu) {
        this.label = menu.getTitle();
        if (menu.getChildren().length == 0) {
            this.hashUrl = menu.getUrl();
            subMenuItems = Collections.emptyList();
        } else {
            this.hashUrl = null;
            this.subMenuItems = Arrays.stream(menu.getChildren())
                .map(WwwMenuItemDto::new)
                .collect(Collectors.toList());
        }
    }

    public String getLabel() {
        return label;
    }

    public String getHashUrl() {
        return hashUrl;
    }

    public List<WwwMenuItemDto> getSubMenuItems() {
        return subMenuItems;
    }

    public boolean isAtomic() {
        return subMenuItems.size() == 0;
    }
}
