package ru.yandex.solomon.gateway.api.internal.yasm;

import java.util.concurrent.CompletableFuture;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monitoring.gateway.AlertStatusRequest;
import ru.yandex.monitoring.gateway.AlertStatusResponse;
import ru.yandex.monitoring.gateway.QueryTopRequest;
import ru.yandex.monitoring.gateway.QueryTopResponse;
import ru.yandex.monitoring.gateway.ReadDataRequest;
import ru.yandex.monitoring.gateway.ReadDataResponse;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Ivan Tsybulin
 */
@ParametersAreNonnullByDefault
public interface YasmGatewayService {

    CompletableFuture<ReadDataResponse> readData(ReadDataRequest request, AuthSubject subject);

    CompletableFuture<QueryTopResponse> queryTop(QueryTopRequest request);

    CompletableFuture<AlertStatusResponse> alertStatus(AlertStatusRequest request);

}
