package ru.yandex.solomon.gateway.api.metrics;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.encode.MetricFormat;
import ru.yandex.monlib.metrics.encode.spack.format.CompressionAlg;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.solomon.metrics.client.MetricsClientMetrics;
import ru.yandex.solomon.selfmon.mon.HttpMetricRegistryEncoder;

/**
 * @author Alexey Trushkin
 */
@RestController
public class MetricsClientMetricsController {

    private final MetricsClientMetrics metrics;
    private final InnerMetricSupplier innerMetricSupplier;

    @Autowired
    public MetricsClientMetricsController(MetricsClientMetrics metrics) {
        this.metrics = metrics;
        innerMetricSupplier = new InnerMetricSupplier();
    }

    @RequestMapping({"/metrics-client/metrics"})
    public ResponseEntity<byte[]> metrics(
            @RequestParam(value = "format", defaultValue = "UNKNOWN") MetricFormat format,
            @RequestParam(value = "compression", defaultValue = "NONE") CompressionAlg compression,
            ServerHttpRequest request)
    {
        return HttpMetricRegistryEncoder.encode(innerMetricSupplier, request, format, compression);
    }

    private class InnerMetricSupplier implements MetricSupplier {

        @Override
        public int estimateCount() {
            return metrics.estimateCount();
        }

        @Override
        public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
            metrics.append(tsMillis, commonLabels, consumer);
        }
    }
}
