package ru.yandex.solomon.gateway.api.old.data;

import java.util.function.Consumer;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Label;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.labels.LabelsBuilder;

/**
 * Special class to register all metrics with "total" values
 *
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
public class MetricCombiner {

    public static void registerWithAllTotals(Labels labels, Consumer<Labels> labelsConsumer) {
        if (labels.isEmpty()) {
            labelsConsumer.accept(labels);
        } else {
            registerWithAllTotalsImpl(labels.toBuilder(), 0, labelsConsumer);
        }
    }

    private static void registerWithAllTotalsImpl(LabelsBuilder builder, int labelIdx, Consumer<Labels> labelsConsumer) {
        if (labelIdx >= builder.size()) {
            labelsConsumer.accept(builder.build());
        } else {
            Label firstLabel = builder.at(labelIdx);
            registerWithAllTotalsImpl(builder, labelIdx + 1, labelsConsumer);
            builder.add(firstLabel.getKey(), "total");
            registerWithAllTotalsImpl(builder, labelIdx + 1, labelsConsumer);
            builder.add(firstLabel);
        }
    }
}
