package ru.yandex.solomon.gateway.api.old.data;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.auth.AuthSubject;

/**
 * @author Oleg Baryshnikov
 */
@ParametersAreNonnullByDefault
class OldDataApiMetrics {
    static final OldDataApiMetrics INSTANCE = new OldDataApiMetrics(MetricRegistry.root());

    private final MetricRegistry registry;

    private OldDataApiMetrics(MetricRegistry registry) {
        this.registry = registry;
    }

    void register(String handler, @Nullable AuthSubject authSubject, String who) {
        String authType = authSubject == null ? "none" : authSubject.getAuthType().name();
        Labels labels = Labels.of("handler", handler, "authType", authType, "who", who);
        MetricCombiner.registerWithAllTotals(labels, labels1 -> registry.rate("oldDataApi.requests.total", labels1).inc());
    }
}
