package ru.yandex.solomon.gateway.api.old.data;

import java.io.PrintWriter;
import java.io.StringWriter;

/**
 * @author Stepan Koltsov
 */
public class WwwExceptionAsJson {
    private String exceptionClassName;
    private String exceptionMessage;
    private String stackTrace;

    public WwwExceptionAsJson() {
    }

    public WwwExceptionAsJson(String exceptionClassName, String exceptionMessage, String stackTrace) {
        this.exceptionClassName = exceptionClassName;
        this.exceptionMessage = exceptionMessage;
        this.stackTrace = stackTrace;
    }

    public String getStackTrace() {
        return stackTrace;
    }

    public String getExceptionClassName() {
        return exceptionClassName;
    }

    public String getExceptionMessage() {
        return exceptionMessage;
    }

    public void setExceptionClassName(String exceptionClassName) {
        this.exceptionClassName = exceptionClassName;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public static WwwExceptionAsJson of(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return new WwwExceptionAsJson(
                e.getClass().getName(),
                e.getMessage() != null ? e.getMessage() : "",
                sw.toString());
    }
}
