package ru.yandex.solomon.gateway.api.old.grafana;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.solomon.expression.NamedGraphData;
import ru.yandex.solomon.expression.analytics.GraphDataLoadRequest;
import ru.yandex.solomon.expression.analytics.GraphDataLoader;
import ru.yandex.solomon.model.timeseries.AggrGraphDataArrayList;

/**
 * @author Vladimir Gordiychuk
 */
@ParametersAreNonnullByDefault
final class ExpGraphDataLoader implements GraphDataLoader {
    private final Map<GraphDataLoadRequest, List<LoadedMetric>> loaded;

    ExpGraphDataLoader(List<LoadedMetrics> loaded) {
        this.loaded = loaded.stream()
                .collect(Collectors.toMap(LoadedMetrics::getRequest, LoadedMetrics::getMetrics));
    }

    @Override
    public NamedGraphData[] loadGraphData(GraphDataLoadRequest request) {
        return loaded.get(request).stream()
                .map(loaded -> {
                    AggrGraphDataArrayList arrayList = loaded.getArchive().toAggrGraphDataArrayList();
                    var type = loaded.getArchive().getType();
                    Metric metric = loaded.getMetric();
                    return new NamedGraphData(
                        metric.getName(),
                        metric.getKey().getType(),
                        "",
                        metric.getLabels(),
                        type,
                        arrayList);
                }).toArray(NamedGraphData[]::new);
    }
}
