package ru.yandex.solomon.gateway.api.old.grafana;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.solomon.auth.AuthSubject;
import ru.yandex.solomon.auth.http.OptionalAuth;
import ru.yandex.solomon.auth.http.OptionalAuthMetrics;

/**
 * @author Vladimir Gordiychuk
 */
@Controller
@RequestMapping("/rest/grafana")
@Import({
    GrafanaMetaDataManager.class,
    GrafanaDataManager.class,
})
@ParametersAreNonnullByDefault
public class GrafanaController {
    private final GrafanaDataManager dataManager;
    private final GrafanaMetaDataManager metaDataManager;

    @Autowired
    public GrafanaController(
        GrafanaDataManager dataManager,
        GrafanaMetaDataManager metaDataManager)
    {
        this.dataManager = dataManager;
        this.metaDataManager = metaDataManager;
    }

    @RequestMapping(value = "/sensors/key/list", method = RequestMethod.POST)
    @ResponseBody
    public CompletableFuture<List<String>> listMetricsKey(
        @OptionalAuth AuthSubject authSubject,
        @RequestBody @Nonnull Map<String, String> labels)
    {
        OptionalAuthMetrics.INSTANCE.register("/rest/grafana/sensors/key/list", authSubject);

        return metaDataManager.grafanaListMetricsKey(authSubject, labels);
    }

    @RequestMapping(value = "/sensors/value/list", method = RequestMethod.POST)
    @ResponseBody
    public CompletableFuture<List<Map<String, String>>> listMetricsValue(
        @OptionalAuth AuthSubject authSubject,
        @RequestBody @Nonnull Map<String, String> labels)
    {
        OptionalAuthMetrics.INSTANCE.register("/rest/grafana/sensors/value/list", authSubject);

        return metaDataManager.grafanaListMetricsValue(authSubject, labels);
    }

    @RequestMapping(value = "/sensors/search", method = RequestMethod.POST)
    @ResponseBody
    public CompletableFuture<List<Map<String, String>>> searchMetricsValue(
            @OptionalAuth AuthSubject authSubject,
            @RequestBody @Nonnull String selectorsText)
    {
        OptionalAuthMetrics.INSTANCE.register("/rest/grafana/sensors/search", authSubject);

        return metaDataManager.grafanaMetricsSearch(authSubject, selectorsText);
    }

    @RequestMapping(value = "/search", method = RequestMethod.POST)
    @ResponseBody
    public CompletableFuture<List<WwwTimeSeries>> search(
        @OptionalAuth AuthSubject authSubject,
        @RequestBody @Nonnull SearchRequest request)
    {
        OptionalAuthMetrics.INSTANCE.register("/rest/grafana/search", authSubject);
        return dataManager.search(authSubject, request);
    }
}
