package ru.yandex.solomon.gateway.api.old.grafana;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricSupplier;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;
import ru.yandex.solomon.selfmon.counters.AsyncMetrics;

@Component
public class GrafanaMetrics implements MetricSupplier {
    private final Map<String, DashboardMetrics> dashboardsById = new ConcurrentHashMap<>();

    DashboardMetrics getDashboardMetrics(String dashboardId) {
        return dashboardsById.computeIfAbsent(dashboardId, DashboardMetrics::new);
    }

    @Override
    public int estimateCount() {
        return dashboardsById.values()
                .stream()
                .mapToInt(DashboardMetrics::estimateCount)
                .sum();
    }

    @Override
    public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
        DashboardMetrics total = new DashboardMetrics("total");
        for (DashboardMetrics dashboard : dashboardsById.values()) {
            dashboard.append(tsMillis, commonLabels, consumer);
            total.combine(dashboard);
        }
        total.append(tsMillis, commonLabels, consumer);
    }

    public static class DashboardMetrics implements MetricSupplier {
        final AsyncMetrics asyncMetrics;
        final Rate readMetrics;
        private final MetricRegistry registry;

        DashboardMetrics(String dashboardId) {
            this.registry = new MetricRegistry(Labels.of("dashboardId", dashboardId));
            this.asyncMetrics = new AsyncMetrics(registry, "grafana.dashboards.request");
            this.readMetrics = registry.rate("grafana.dashboards.read.sensors.rate");
        }

        @Override
        public int estimateCount() {
            return registry.estimateCount();
        }

        @Override
        public void append(long tsMillis, Labels commonLabels, MetricConsumer consumer) {
            registry.append(tsMillis, commonLabels, consumer);
        }

        void combine(DashboardMetrics target) {
            this.asyncMetrics.combine(target.asyncMetrics);
            this.readMetrics.combine(target.readMetrics);
        }
    }
}
